/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.sprites;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.IntSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.mapping.tile.floor.OverlapLayout;
import technology.rocketjump.undermount.mapping.tile.floor.OverlapLayoutAtlas;

@Singleton
public class MasksSpriteCache {
    private final OverlapLayoutAtlas overlapLayoutAtlas;
    private final Map<String, IntMap<Array<Sprite>>> typeToLayoutToSpriteMap = new HashMap<String, IntMap<Array<Sprite>>>();

    @Inject
    public MasksSpriteCache(OverlapLayoutAtlas overlapLayoutAtlas, TextureAtlasRepository textureAtlasRepository) {
        this.overlapLayoutAtlas = overlapLayoutAtlas;
        TextureAtlas textureAtlas = textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.MASKS_TEXTURE_ATLAS);
        String overlapType = "organic";
        IntMap layoutToSpriteMap = new IntMap();
        IntSet.IntSetIterator uniqueLayoutIterator = overlapLayoutAtlas.getUniqueLayoutIds().iterator();
        while (uniqueLayoutIterator.hasNext) {
            int uniqueLayoutId = uniqueLayoutIterator.next();
            if (uniqueLayoutId == 0) continue;
            Array<Sprite> spriteArray = textureAtlas.createSprites(overlapType + "_" + uniqueLayoutId);
            layoutToSpriteMap.put(uniqueLayoutId, spriteArray);
            OverlapLayout originalayout = new OverlapLayout(uniqueLayoutId);
            OverlapLayout flipX = originalayout.flipX();
            Array<Sprite> flippedXSprites = new Array<Sprite>(spriteArray.size);
            for (Sprite originalSprite : spriteArray) {
                Sprite flippedXSprite = new Sprite(originalSprite);
                flippedXSprite.setFlip(true, false);
                flippedXSprites.add(flippedXSprite);
            }
            layoutToSpriteMap.put(flipX.getId(), flippedXSprites);
            OverlapLayout flipY = originalayout.flipY();
            Array<Sprite> flippedYSprites = new Array<Sprite>(spriteArray.size);
            for (Sprite originalSprite : spriteArray) {
                Sprite flippedYSprite = new Sprite(originalSprite);
                flippedYSprite.setFlip(false, true);
                flippedYSprites.add(flippedYSprite);
            }
            layoutToSpriteMap.put(flipY.getId(), flippedYSprites);
            OverlapLayout flipXY = originalayout.flipX().flipY();
            Array<Sprite> flippedXYSprites = new Array<Sprite>(spriteArray.size);
            for (Sprite originalSprite : spriteArray) {
                Sprite flippeXYSprite = new Sprite(originalSprite);
                flippeXYSprite.setFlip(true, true);
                flippedXYSprites.add(flippeXYSprite);
            }
            layoutToSpriteMap.put(flipXY.getId(), flippedXYSprites);
        }
        uniqueLayoutIterator.reset();
        this.typeToLayoutToSpriteMap.put(overlapType, layoutToSpriteMap);
    }

    public Sprite getMaskForOverlap(OverlapLayout layout, long seed) {
        OverlapLayoutAtlas.OverlapAtlasEntry atlasEntry = this.overlapLayoutAtlas.getByLayoutId(layout.getId());
        IntMap<Array<Sprite>> layoutToSpriteMap = this.typeToLayoutToSpriteMap.get("organic");
        Array<Sprite> spriteArray = layoutToSpriteMap.get(atlasEntry.getUnflippedLayout().getId());
        int spriteNum = Math.abs((int)seed) % spriteArray.size;
        return spriteArray.get(spriteNum);
    }
}

